/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CharacterCollision
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.m_radius = 0.0f;
        shape.setAsEdge(new Vec2(-8.0f, 1.0f), new Vec2(-6.0f, 1.0f));
        ground.createFixture(shape, 0.0f);
        shape.setAsEdge(new Vec2(-6.0f, 1.0f), new Vec2(-4.0f, 1.0f));
        ground.createFixture(shape, 0.0f);
        shape.setAsEdge(new Vec2(-4.0f, 1.0f), new Vec2(-2.0f, 1.0f));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(1.0f, 1.0f, new Vec2(4.0f, 3.0f), 0.0f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(1.0f, 1.0f, new Vec2(6.0f, 3.0f), 0.0f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(1.0f, 1.0f, new Vec2(8.0f, 3.0f), 0.0f);
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        float d = 2.0f * Settings.polygonRadius;
        shape.setAsEdge(new Vec2(-1.0f + d, 3.0f), new Vec2(1.0f - d, 3.0f));
        ground.createFixture(shape, 0.0f);
        shape.setAsEdge(new Vec2(1.0f, 3.0f + d), new Vec2(1.0f, 5.0f - d));
        ground.createFixture(shape, 0.0f);
        shape.setAsEdge(new Vec2(1.0f - d, 5.0f), new Vec2(-1.0f + d, 5.0f));
        ground.createFixture(shape, 0.0f);
        shape.setAsEdge(new Vec2(-1.0f, 5.0f - d), new Vec2(-1.0f, 3.0f + d));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        bd.position.set(-3.0f, 5.0f);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        Body body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.5f, 0.5f);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 20.0f;
        body.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(-5.0f, 5.0f);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        float angle = 0.0f;
        float delta = 1.0471976f;
        Vec2[] vertices = new Vec2[6];
        for (int i = 0; i < 6; ++i) {
            vertices[i] = new Vec2(0.5f * MathUtils.cos(angle), 0.5f * MathUtils.sin(angle));
            angle += delta;
        }
        PolygonShape shape2 = new PolygonShape();
        shape2.set(vertices, 6);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = shape2;
        fd2.density = 20.0f;
        body.createFixture(fd2);
        bd = new BodyDef();
        bd.position.set(3.0f, 5.0f);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        CircleShape shape22 = new CircleShape();
        shape22.m_radius = 0.5f;
        fd = new FixtureDef();
        fd.shape = shape22;
        fd.density = 20.0f;
        body.createFixture(fd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("This tests various character collision shapes");
    }

    @Override
    public String getTestName() {
        return "Character Collision";
    }
}

