/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CircleStress
extends TestbedTest {
    private static final long JOINT_TAG = 1L;
    private RevoluteJoint joint;

    @Override
    public Long getTag(Joint argJoint) {
        if (argJoint == this.joint) {
            return 1L;
        }
        return null;
    }

    @Override
    public void processJoint(Joint argJoint, Long argTag) {
        if (argTag == 1L) {
            this.joint = (RevoluteJoint)argJoint;
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0f, 20.0f);
    }

    @Override
    public float getDefaultCameraScale() {
        return 5.0f;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        Body leftWall = null;
        Body rightWall = null;
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0f, 10.0f);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.STATIC;
        bd2.position = new Vec2(0.0f, -10.0f);
        Body b = this.getWorld().createBody(bd2);
        FixtureDef fd = new FixtureDef();
        fd.shape = sd;
        fd.friction = 1.0f;
        b.createFixture(fd);
        sd.setAsBox(3.0f, 50.0f);
        bd2 = new BodyDef();
        bd2.position = new Vec2(45.0f, 25.0f);
        rightWall = this.getWorld().createBody(bd2);
        rightWall.createFixture(sd, 0.0f);
        bd2.position = new Vec2(-45.0f, 25.0f);
        leftWall = this.getWorld().createBody(bd2);
        leftWall.createFixture(sd, 0.0f);
        bd2 = new BodyDef();
        sd.setAsBox(20.0f, 3.0f);
        bd2.angle = -0.7853982f;
        bd2.position = new Vec2(-35.0f, 8.0f);
        Body myBod = this.getWorld().createBody(bd2);
        myBod.createFixture(sd, 0.0f);
        bd2.angle = 0.7853982f;
        bd2.position = new Vec2(35.0f, 8.0f);
        myBod = this.getWorld().createBody(bd2);
        myBod.createFixture(sd, 0.0f);
        sd.setAsBox(50.0f, 10.0f);
        bd2.type = BodyType.STATIC;
        bd2.angle = 0.0f;
        bd2.position = new Vec2(0.0f, 75.0f);
        b = this.getWorld().createBody(bd2);
        fd.shape = sd;
        fd.friction = 1.0f;
        b.createFixture(fd);
        FixtureDef fd2 = new FixtureDef();
        BodyDef bd3 = new BodyDef();
        bd3.type = BodyType.DYNAMIC;
        int numPieces = 5;
        float radius = 6.0f;
        bd3.position = new Vec2(0.0f, 10.0f);
        Body body = this.getWorld().createBody(bd3);
        for (int i = 0; i < numPieces; ++i) {
            CircleShape cd = new CircleShape();
            cd.m_radius = 1.2f;
            fd2.shape = cd;
            fd2.density = 25.0f;
            fd2.friction = 0.1f;
            fd2.restitution = 0.9f;
            float xPos = radius * (float)Math.cos(Math.PI * 2 * (double)((float)i / (float)numPieces));
            float yPos = radius * (float)Math.sin(Math.PI * 2 * (double)((float)i / (float)numPieces));
            cd.m_p.set(xPos, yPos);
            body.createFixture(fd2);
        }
        body.setBullet(false);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body, this.getGroundBody(), body.getPosition());
        rjd.motorSpeed = (float)Math.PI;
        rjd.maxMotorTorque = 1000000.0f;
        rjd.enableMotor = true;
        this.joint = (RevoluteJoint)this.getWorld().createJoint(rjd);
        int loadSize = 41;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < loadSize; ++i) {
                CircleShape circ = new CircleShape();
                BodyDef bod = new BodyDef();
                bod.type = BodyType.DYNAMIC;
                circ.m_radius = 1.0f + (i % 2 == 0 ? 1.0f : -1.0f) * 0.5f * MathUtils.randomFloat(0.5f, 1.0f);
                FixtureDef fd22 = new FixtureDef();
                fd22.shape = circ;
                fd22.density = circ.m_radius * 1.5f;
                fd22.friction = 0.5f;
                fd22.restitution = 0.7f;
                float xPos = -39.0f + (float)(2 * i);
                float yPos = 50.0f + (float)j;
                bod.position = new Vec2(xPos, yPos);
                Body myBody = this.getWorld().createBody(bod);
                myBody.createFixture(fd22);
            }
        }
        this.getWorld().setGravity(new Vec2(0.0f, -50.0f));
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 's': {
                this.joint.setMotorSpeed(0.0f);
                break;
            }
            case '1': {
                this.joint.setMotorSpeed((float)Math.PI);
                break;
            }
            case '2': {
                this.joint.setMotorSpeed((float)Math.PI * 2);
                break;
            }
            case '3': {
                this.joint.setMotorSpeed((float)Math.PI * 3);
                break;
            }
            case '4': {
                this.joint.setMotorSpeed((float)Math.PI * 6);
                break;
            }
            case '5': {
                this.joint.setMotorSpeed((float)Math.PI * 10);
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press 's' to stop, and '1' - '5' to change speeds");
    }

    @Override
    public String getTestName() {
        return "Circle Stress Test";
    }
}

