/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class SensorTest
extends TestbedTest {
    int e_count = 7;
    Fixture m_sensor;
    Body[] m_bodies = new Body[this.e_count];
    BoolWrapper[] m_touching = new BoolWrapper[this.e_count];

    @Override
    public void initTest(boolean argDeserialized) {
        for (int i = 0; i < this.m_touching.length; ++i) {
            this.m_touching[i] = new BoolWrapper();
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        Shape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        shape = new CircleShape();
        ((CircleShape)shape).m_radius = 5.0f;
        ((CircleShape)shape).m_p.set(0.0f, 10.0f);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.isSensor = true;
        this.m_sensor = ground.createFixture(fd);
        CircleShape shape2 = new CircleShape();
        shape2.m_radius = 1.0f;
        for (int i = 0; i < this.e_count; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set(-10.0f + 3.0f * (float)i, 20.0f);
            bd2.userData = this.m_touching[i];
            this.m_touching[i].tf = false;
            this.m_bodies[i] = this.getWorld().createBody(bd2);
            this.m_bodies[i].createFixture(shape2, 1.0f);
        }
    }

    @Override
    public void beginContact(Contact contact) {
        Object userData;
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (fixtureA == this.m_sensor && (userData = fixtureB.getBody().getUserData()) != null) {
            ((BoolWrapper)userData).tf = true;
        }
        if (fixtureB == this.m_sensor && (userData = fixtureA.getBody().getUserData()) != null) {
            ((BoolWrapper)userData).tf = true;
        }
    }

    @Override
    public void endContact(Contact contact) {
        Object userData;
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (fixtureA == this.m_sensor && (userData = fixtureB.getBody().getUserData()) != null) {
            ((BoolWrapper)userData).tf = false;
        }
        if (fixtureB == this.m_sensor && (userData = fixtureA.getBody().getUserData()) != null) {
            ((BoolWrapper)userData).tf = false;
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        for (int i = 0; i < this.e_count; ++i) {
            Vec2 position;
            if (!this.m_touching[i].tf) continue;
            Body body = this.m_bodies[i];
            Body ground = this.m_sensor.getBody();
            CircleShape circle = (CircleShape)this.m_sensor.getShape();
            Vec2 center = ground.getWorldPoint(circle.m_p);
            Vec2 d = center.sub(position = body.getPosition());
            if (d.lengthSquared() < 1.4210855E-14f) continue;
            d.normalize();
            Vec2 F = d.mulLocal(100.0f);
            body.applyForce(F, position);
        }
    }

    @Override
    public String getTestName() {
        return "Sensor Test";
    }

    class BoolWrapper {
        boolean tf;

        BoolWrapper() {
        }
    }
}

