/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ShapeEditing
extends TestbedTest {
    Body m_body;
    Fixture m_fixture1;
    Fixture m_fixture2;

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 10.0f);
        this.m_body = this.getWorld().createBody(bd);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(4.0f, 4.0f, new Vec2(0.0f, 0.0f), 0.0f);
        this.m_fixture1 = this.m_body.createFixture(shape2, 10.0f);
        this.m_fixture2 = null;
    }

    @Override
    public void keyPressed(char key, int argKeyCode) {
        switch (key) {
            case 'c': {
                if (this.m_fixture2 != null) break;
                CircleShape shape = new CircleShape();
                shape.m_radius = 3.0f;
                shape.m_p.set(0.5f, -4.0f);
                this.m_fixture2 = this.m_body.createFixture(shape, 10.0f);
                this.m_body.setAwake(true);
                break;
            }
            case 'd': {
                if (this.m_fixture2 == null) break;
                this.m_body.destroyFixture(this.m_fixture2);
                this.m_fixture2 = null;
                this.m_body.setAwake(true);
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press: (c) create a shape, (d) destroy a shape.");
    }

    @Override
    public String getTestName() {
        return "Shape Editing";
    }
}

