/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class VaryingRestitution
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        CircleShape shape2 = new CircleShape();
        shape2.m_radius = 1.0f;
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 1.0f;
        float[] restitution = new float[]{0.0f, 0.1f, 0.3f, 0.5f, 0.75f, 0.9f, 1.0f};
        for (int i = 0; i < 7; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set(-10.0f + 3.0f * (float)i, 20.0f);
            Body body = this.getWorld().createBody(bd2);
            fd.restitution = restitution[i];
            body.createFixture(fd);
        }
    }

    @Override
    public String getTestName() {
        return "Varying Restitution";
    }
}

