/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CharSet {
    private String name;
    private boolean mutable = false;
    private File source;
    private boolean[] chars = new boolean[256];

    private CharSet() {
    }

    public CharSet(int start, int end, String name) {
        this.name = name;
        for (int i = start; i <= end; ++i) {
            this.set(i, true);
        }
    }

    public void set(int c, boolean included) {
        this.chars[c] = included;
    }

    public CharSet copy() {
        CharSet copy = new CharSet();
        copy.name = this.name;
        copy.source = this.source;
        copy.mutable = true;
        copy.chars = new boolean[256];
        System.arraycopy(this.chars, 0, copy.chars, 0, this.chars.length);
        return copy;
    }

    public CharSet(File source) throws IOException {
        this.source = source;
        this.mutable = true;
        DataInputStream din = new DataInputStream(new FileInputStream(source));
        this.name = din.readUTF();
        for (int i = 0; i < 256; ++i) {
            this.chars[i] = din.readBoolean();
        }
        din.close();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void save(File file) throws IOException {
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));
        dout.writeUTF(this.name);
        for (int i = 0; i < 256; ++i) {
            dout.writeBoolean(this.chars[i]);
        }
        dout.close();
    }

    public File getSource() {
        return this.source;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean includes(char c) {
        return this.chars[c];
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

