/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero.truetype;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.newdawn.slick.tools.hiero.truetype.FontFileReader;
import org.newdawn.slick.tools.hiero.truetype.IOUtils;
import org.newdawn.slick.tools.hiero.truetype.StatusListener;
import org.newdawn.slick.tools.hiero.truetype.TTFFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FontData {
    private static long MAX_FILE_SIZE = 2000000L;
    private static String userhome = System.getProperty("user.home");
    private static File[] win32 = new File[]{new File("c:/windows/fonts")};
    private static File[] macos = new File[]{new File("/System/Library/Fonts/"), new File("/Library/Fonts/"), new File("/System Folder/Fonts/"), new File("/Network/Library/Fonts/"), new File(userhome + "/Library/Fonts")};
    private static File[] linux = new File[]{new File("/usr/share/fonts"), new File("/usr/share/X11/fonts")};
    private static boolean DEBUG = true;
    private static ArrayList families = new ArrayList();
    private static ArrayList fonts;
    private static HashMap plain;
    private static HashMap bold;
    private static HashMap italic;
    private static HashMap bolditalic;
    private static StatusListener statusListener;
    private static ArrayList processed;
    private Font javaFont;
    private float size;
    private int upem;
    private Map ansiKerning;
    private int[] charWidth;
    private String fontName;
    private String familyName;

    public static void setStatusListener(StatusListener listener) {
        statusListener = listener;
    }

    public static String[] getFamilyNames() {
        if (fonts == null) {
            FontData.getAllFonts();
        }
        return families.toArray(new String[0]);
    }

    public static FontData getPlain(String familyName) {
        FontData data = (FontData)plain.get(familyName);
        return data;
    }

    public static FontData getBold(String familyName) {
        FontData data = (FontData)bold.get(familyName);
        return data;
    }

    public static FontData getBoldItalic(String familyName) {
        FontData data = (FontData)bolditalic.get(familyName);
        return data;
    }

    public static FontData getItalic(String familyName) {
        FontData data = (FontData)italic.get(familyName);
        return data;
    }

    public static FontData getStyled(String familyName, int style) {
        boolean i;
        boolean b = (style & 1) != 0;
        boolean bl = i = (style & 2) != 0;
        if (b & i) {
            return FontData.getBoldItalic(familyName);
        }
        if (b) {
            return FontData.getBold(familyName);
        }
        if (i) {
            return FontData.getItalic(familyName);
        }
        return FontData.getPlain(familyName);
    }

    private static void processFontDirectory(File dir, ArrayList fonts) {
        if (!dir.exists()) {
            return;
        }
        if (processed.contains(dir)) {
            return;
        }
        processed.add(dir);
        File[] sources = dir.listFiles();
        if (sources == null) {
            return;
        }
        for (int j = 0; j < sources.length; ++j) {
            File source = sources[j];
            if (source.getName().equals(".") || source.getName().equals("..")) continue;
            if (source.isDirectory()) {
                FontData.processFontDirectory(source, fonts);
                continue;
            }
            if (!source.getName().toLowerCase().endsWith(".ttf")) continue;
            try {
                if (statusListener != null) {
                    statusListener.updateStatus("Processing " + source.getName());
                }
                FontData data = new FontData(new FileInputStream(source), 1.0f);
                fonts.add(data);
                String famName = data.getFamilyName();
                if (!families.contains(famName)) {
                    families.add(famName);
                }
                boolean bo = data.getJavaFont().isBold();
                boolean it = data.getJavaFont().isItalic();
                if (bo && it) {
                    bolditalic.put(famName, data);
                    continue;
                }
                if (bo) {
                    bold.put(famName, data);
                    continue;
                }
                if (it) {
                    italic.put(famName, data);
                    continue;
                }
                plain.put(famName, data);
                continue;
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.err.println("Unable to process: " + source.getAbsolutePath() + " (" + e.getClass() + ": " + e.getMessage() + ")");
                }
                if (statusListener == null) continue;
                statusListener.updateStatus("Unable to process: " + source.getName());
            }
        }
    }

    public static FontData[] getAllFonts() {
        if (fonts == null) {
            fonts = new ArrayList();
            String os = System.getProperty("os.name");
            File[] locs = new File[]{};
            if (os.startsWith("Windows")) {
                locs = win32;
            }
            if (os.startsWith("Linux")) {
                locs = linux;
            }
            if (os.startsWith("Mac OS")) {
                locs = macos;
            }
            for (int i = 0; i < locs.length; ++i) {
                File loc = locs[i];
                FontData.processFontDirectory(loc, fonts);
            }
            if (os.startsWith("Linux")) {
                FontData.locateLinuxFonts(new File("/etc/fonts/fonts.conf"));
            }
        }
        return fonts.toArray(new FontData[0]);
    }

    private static void locateLinuxFonts(File file) {
        if (!file.exists()) {
            System.err.println("Unable to open: " + file.getAbsolutePath());
            return;
        }
        try {
            InputStream in = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            PrintStream pout = new PrintStream(temp);
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.indexOf("DOCTYPE") != -1) continue;
                pout.println(line);
            }
            in = new ByteArrayInputStream(temp.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList dirs = document.getElementsByTagName("dir");
            for (int i = 0; i < dirs.getLength(); ++i) {
                Element element = (Element)dirs.item(i);
                String dir = element.getFirstChild().getNodeValue();
                if (dir.startsWith("~")) {
                    dir = dir.substring(1);
                    dir = userhome + dir;
                }
                FontData.addFontDirectory(new File(dir));
            }
            NodeList includes = document.getElementsByTagName("include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Element element = (Element)dirs.item(i);
                String inc = element.getFirstChild().getNodeValue();
                if (inc.startsWith("~")) {
                    inc = inc.substring(1);
                    inc = userhome + inc;
                }
                FontData.locateLinuxFonts(new File(inc));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to process: " + file.getAbsolutePath());
        }
    }

    public static void addFontDirectory(File dir) {
        FontData.processFontDirectory(dir, fonts);
    }

    private FontData(InputStream ttf, float size) throws IOException {
        if ((long)ttf.available() > MAX_FILE_SIZE) {
            throw new IOException("Can't load font - too big");
        }
        byte[] data = IOUtils.toByteArray(ttf);
        if ((long)data.length > MAX_FILE_SIZE) {
            throw new IOException("Can't load font - too big");
        }
        this.size = size;
        try {
            this.javaFont = Font.createFont(0, new ByteArrayInputStream(data));
            TTFFile rawFont = new TTFFile();
            if (!rawFont.readFont(new FontFileReader(data))) {
                throw new IOException("Invalid font file");
            }
            this.upem = rawFont.getUPEM();
            this.ansiKerning = rawFont.getAnsiKerning();
            this.charWidth = rawFont.getAnsiWidth();
            this.fontName = rawFont.getPostScriptName();
            this.familyName = rawFont.getFamilyName();
            String name = this.getName();
            System.err.println("Loaded: " + name + " (" + data.length + ")");
            boolean bo = false;
            boolean it = false;
            if (name.indexOf(44) >= 0) {
                if ((name = name.substring(name.indexOf(44))).indexOf("Bold") >= 0) {
                    bo = true;
                }
                if (name.indexOf("Italic") >= 0) {
                    it = true;
                }
            }
            if (bo & it) {
                this.javaFont = this.javaFont.deriveFont(3);
            } else if (bo) {
                this.javaFont = this.javaFont.deriveFont(1);
            } else if (it) {
                this.javaFont = this.javaFont.deriveFont(2);
            }
        }
        catch (FontFormatException e) {
            IOException x = new IOException("Failed to read font");
            x.initCause(e);
            throw x;
        }
    }

    private FontData() {
    }

    public FontData deriveFont(float size) {
        return this.deriveFont(size, this.javaFont.getStyle());
    }

    public FontData deriveFont(float size, int style) {
        FontData original = FontData.getStyled(this.getFamilyName(), style);
        FontData data = new FontData();
        data.size = size;
        data.javaFont = original.javaFont.deriveFont(style, size);
        data.upem = this.upem;
        data.ansiKerning = this.ansiKerning;
        data.charWidth = this.charWidth;
        return data;
    }

    public String getName() {
        return this.fontName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public float getSize() {
        return this.size;
    }

    public Font getJavaFont() {
        return this.javaFont;
    }

    public int getKerning(char first, char second) {
        Map toMap = (Map)this.ansiKerning.get(new Integer(first));
        if (toMap == null) {
            return 0;
        }
        Integer kerning = (Integer)toMap.get(new Integer(second));
        if (kerning == null) {
            return 0;
        }
        return Math.round(this.convertUnitToEm(this.size, kerning));
    }

    public float convertUnitToEm(float ptSize, int units) {
        return (float)units * ptSize / (float)this.upem;
    }

    public float getAdvance(char c) {
        return Math.round(this.convertUnitToEm(this.size, this.charWidth[c]));
    }

    public String toString() {
        return "[Font Data face='" + this.getName() + "' size=" + this.size + " bold=" + this.javaFont.isBold() + " italic=" + this.javaFont.isItalic() + "]";
    }

    static {
        plain = new HashMap();
        bold = new HashMap();
        italic = new HashMap();
        bolditalic = new HashMap();
        processed = new ArrayList();
    }
}

